//Falcon-180B DATASET v1.0 Category: Temperature monitor ; Style: Ken Thompson
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define MAX_SENSORS 10
#define MAX_SENSOR_NAME_LENGTH 16

#define TEMP_MAX 1000
#define TEMP_MIN -273.15

typedef struct {
    char name[MAX_SENSOR_NAME_LENGTH];
    double temperature;
} sensor_t;

int num_sensors = 0;
sensor_t sensors[MAX_SENSORS];

void add_sensor(char* name) {
    if (num_sensors >= MAX_SENSORS) {
        printf("Error: Too many sensors.\n");
        return;
    }

    strncpy(sensors[num_sensors].name, name, MAX_SENSOR_NAME_LENGTH);
    num_sensors++;
}

void remove_sensor(int index) {
    if (index >= num_sensors || index < 0) {
        printf("Error: Invalid sensor index.\n");
        return;
    }

    num_sensors--;
    for (int i = index; i < num_sensors; i++) {
        strncpy(sensors[i].name, sensors[i+1].name, MAX_SENSOR_NAME_LENGTH);
        sensors[i].temperature = sensors[i+1].temperature;
    }
}

void set_temperature(int index, double temp) {
    if (index >= num_sensors || index < 0) {
        printf("Error: Invalid sensor index.\n");
        return;
    }

    if (temp < TEMP_MIN || temp > TEMP_MAX) {
        printf("Error: Temperature out of range.\n");
        return;
    }

    sensors[index].temperature = temp;
}

void print_sensors() {
    printf("Sensors:\n");
    for (int i = 0; i < num_sensors; i++) {
        printf("%s: %.2f°C\n", sensors[i].name, sensors[i].temperature);
    }
}

int main() {
    add_sensor("CPU");
    add_sensor("GPU");

    set_temperature(0, 50.0);
    set_temperature(1, 60.0);

    print_sensors();

    remove_sensor(1);

    print_sensors();

    return 0;
}