//Falcon-180B DATASET v1.0 Category: Time Travel Simulator ; Style: careful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <limits.h>

#define MAX_EVENTS 1000 // Maximum number of events
#define MAX_TIME 1000 // Maximum time in seconds

typedef struct {
    int time;
    int type;
    int data;
} Event;

int event_compare(const void *a, const void *b) {
    const Event *event_a = a;
    const Event *event_b = b;

    if (event_a->time < event_b->time) {
        return -1;
    } else if (event_a->time > event_b->time) {
        return 1;
    } else {
        return 0;
    }
}

int main() {
    srand(time(NULL));

    Event events[MAX_EVENTS];
    int num_events = 0;

    int start_time = rand() % MAX_TIME;
    int end_time = start_time + rand() % (MAX_TIME - start_time);

    events[num_events++] = (Event) {.time = start_time,.type = 0,.data = 0 };
    events[num_events++] = (Event) {.time = end_time,.type = 1,.data = 0 };

    qsort(events, num_events, sizeof(Event), event_compare);

    for (int i = 0; i < num_events; i++) {
        printf("%d: ", events[i].time);
        if (events[i].type == 0) {
            printf("Start\n");
        } else if (events[i].type == 1) {
            printf("End\n");
        }
    }

    return 0;
}