//GPT-4o-mini DATASET v1.0 Category: Poker Game ; Style: happy
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_CARDS 5
#define HAND_SIZE 2
#define TOTAL_CARDS 52

const char *SUITS[] = {"Hearts", "Diamonds", "Clubs", "Spades"};
const char *RANKS[] = {"2", "3", "4", "5", "6", "7", "8", "9", "10", "J", "Q", "K", "A"};

typedef struct {
    char *rank;
    char *suit;
} Card;

typedef struct {
    Card hand[HAND_SIZE];
    int score;
} Player;

Card deck[TOTAL_CARDS];
int deckPos = 0;

void initializeDeck() {
    deckPos = 0;
    for (int suit = 0; suit < 4; ++suit) {
        for (int rank = 0; rank < 13; ++rank) {
            deck[deckPos].rank = (char *)RANKS[rank];
            deck[deckPos].suit = (char *)SUITS[suit];
            deckPos++;
        }
    }
}

void shuffleDeck() {
    srand(time(NULL));
    for (int i = 0; i < TOTAL_CARDS; ++i) {
        int j = rand() % TOTAL_CARDS;
        Card temp = deck[i];
        deck[i] = deck[j];
        deck[j] = temp;
    }
}

void dealCard(Player *player) {
    if (deckPos >= TOTAL_CARDS) {
        printf("No more cards in the deck!\n");
        return;
    }
    player->hand[player->score++] = deck[deckPos++];
}

void printHand(Player *player) {
    printf("Player's Hand:\n");
    for (int i = 0; i < player->score; ++i) {
        printf("%s of %s\n", player->hand[i].rank, player->hand[i].suit);
    }
}

int getHandValue(Player *player) {
    int value = 0;
    for (int i = 0; i < player->score; ++i) {
        if (strcmp(player->hand[i].rank, "A") == 0) {
            value += 11;  // Consider Ace as 11 first
        } else if (strcmp(player->hand[i].rank, "K") == 0 || strcmp(player->hand[i].rank, "Q") == 0 || strcmp(player->hand[i].rank, "J") == 0) {
            value += 10;  // Face cards are worth 10
        } else {
            value += atoi(player->hand[i].rank);
        }
    }
    // Adjust for Aces being low (1) if value exceeds 21
    while (value > 21) {
        for (int i = 0; i < player->score; ++i) {
            if (strcmp(player->hand[i].rank, "A") == 0) {
                value -= 10;  // Count Ace as 1
                break;
            }
        }
    }
    return value;
}

void playGame() {
    Player player1 = { .score = 0 };
    Player player2 = { .score = 0 };

    initializeDeck();
    shuffleDeck();

    printf("Welcome to the Happy Poker Game!\n");

    for (int i = 0; i < HAND_SIZE; ++i) {
        dealCard(&player1);
        dealCard(&player2);
    }

    printHand(&player1);
    printHand(&player2);

    player1.score = getHandValue(&player1);
    player2.score = getHandValue(&player2);

    printf("Player 1 score: %d\n", player1.score);
    printf("Player 2 score: %d\n", player2.score);

    if (player1.score > player2.score) {
        printf("Player 1 wins with a score of %d! 🎉\n", player1.score);
    } else if (player2.score > player1.score) {
        printf("Player 2 wins with a score of %d! 🎉\n", player2.score);
    } else {
        printf("It's a tie! Both players have %d points! 🎈\n", player1.score);
    }
}

int main() {
    playGame();
    return 0;
}