//Falcon-180B DATASET v1.0 Category: Password management ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_PASSWORDS 1000
#define MAX_PASSWORD_LENGTH 100

typedef struct {
    char site[MAX_PASSWORD_LENGTH];
    char username[MAX_PASSWORD_LENGTH];
    char password[MAX_PASSWORD_LENGTH];
} Password;

Password passwords[MAX_PASSWORDS];
int numPasswords = 0;

void addPassword(char* site, char* username, char* password) {
    strcpy(passwords[numPasswords].site, site);
    strcpy(passwords[numPasswords].username, username);
    strcpy(passwords[numPasswords].password, password);
    numPasswords++;
}

void removePassword(int index) {
    numPasswords--;
    for (int i = index; i < numPasswords; i++) {
        strcpy(passwords[i].site, passwords[i+1].site);
        strcpy(passwords[i].username, passwords[i+1].username);
        strcpy(passwords[i].password, passwords[i+1].password);
    }
}

void editPassword(int index, char* site, char* username, char* password) {
    strcpy(passwords[index].site, site);
    strcpy(passwords[index].username, username);
    strcpy(passwords[index].password, password);
}

void listPasswords() {
    printf("Site\tUsername\tPassword\n");
    for (int i = 0; i < numPasswords; i++) {
        printf("%s\t%s\t%s\n", passwords[i].site, passwords[i].username, passwords[i].password);
    }
}

int main() {
    addPassword("google.com", "johndoe", "password123");
    addPassword("facebook.com", "janedoe", "iloveyou");
    listPasswords();
    removePassword(0);
    listPasswords();
    editPassword(0, "google.com", "admin", "admin123");
    listPasswords();
    return 0;
}