//GEMINI-pro DATASET v1.0 Category: Data structures visualization ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 100

typedef struct node {
    int data;
    struct node *next;
} node;

typedef struct list {
    node *head;
    node *tail;
    int size;
} list;

list *create_list() {
    list *l = malloc(sizeof(list));
    l->head = NULL;
    l->tail = NULL;
    l->size = 0;
    return l;
}

void insert_at_head(list *l, int data) {
    node *new_node = malloc(sizeof(node));
    new_node->data = data;
    new_node->next = l->head;
    l->head = new_node;
    if (l->tail == NULL) {
        l->tail = new_node;
    }
    l->size++;
}

void insert_at_tail(list *l, int data) {
    node *new_node = malloc(sizeof(node));
    new_node->data = data;
    new_node->next = NULL;
    if (l->tail == NULL) {
        l->head = new_node;
        l->tail = new_node;
    } else {
        l->tail->next = new_node;
        l->tail = new_node;
    }
    l->size++;
}

void insert_at_index(list *l, int index, int data) {
    if (index == 0) {
        insert_at_head(l, data);
    } else if (index == l->size) {
        insert_at_tail(l, data);
    } else {
        node *new_node = malloc(sizeof(node));
        new_node->data = data;
        node *current = l->head;
        for (int i = 0; i < index - 1; i++) {
            current = current->next;
        }
        new_node->next = current->next;
        current->next = new_node;
        l->size++;
    }
}

void delete_at_head(list *l) {
    if (l->size == 0) {
        return;
    }
    node *current = l->head;
    l->head = l->head->next;
    if (l->head == NULL) {
        l->tail = NULL;
    }
    free(current);
    l->size--;
}

void delete_at_tail(list *l) {
    if (l->size == 0) {
        return;
    }
    node *current = l->head;
    while (current->next != l->tail) {
        current = current->next;
    }
    l->tail = current;
    free(current->next);
    l->size--;
}

void delete_at_index(list *l, int index) {
    if (index == 0) {
        delete_at_head(l);
    } else if (index == l->size - 1) {
        delete_at_tail(l);
    } else {
        node *current = l->head;
        for (int i = 0; i < index - 1; i++) {
            current = current->next;
        }
        node *temp = current->next;
        current->next = current->next->next;
        free(temp);
        l->size--;
    }
}

int get_data_at_index(list *l, int index) {
    if (index < 0 || index >= l->size) {
        return -1;
    }
    node *current = l->head;
    for (int i = 0; i < index; i++) {
        current = current->next;
    }
    return current->data;
}

void print_list(list *l) {
    node *current = l->head;
    while (current != NULL) {
        printf("%d ", current->data);
        current = current->next;
    }
    printf("\n");
}

int main() {
    list *l = create_list();
    insert_at_head(l, 1);
    insert_at_tail(l, 2);
    insert_at_index(l, 1, 3);
    print_list(l); // 1 3 2
    delete_at_head(l);
    print_list(l); // 3 2
    delete_at_tail(l);
    print_list(l); // 3
    delete_at_index(l, 0);
    print_list(l); // empty list
    return 0;
}