
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_BUFFER_SIZE 1024

typedef struct {
    char *buffer;
    int size;
} Buffer;

Buffer *allocate_buffer(int size) {
    Buffer *b = malloc(sizeof(Buffer));
    b->buffer = malloc(size);
    b->size = size;
    return b;
}

void sanitize_input(Buffer *b) {
    char *input = NULL;
    int input_length = 0;

    printf("Enter your input: ");

    
    input = getline(&input_length, NULL, stdin);

    
    if (input_length > 0 && input[input_length - 1] == '\n') {
        input[input_length - 1] = '\0';
    }

    
    b->buffer = realloc(b->buffer, input_length);
    memcpy(b->buffer, input, input_length);

    
    free(input);
}

int main() {
    Buffer *b = allocate_buffer(MAX_BUFFER_SIZE);
    sanitize_input(b);

    printf("Your sanitized input: %s\n", b->buffer);

    
    free(b->buffer);
    free(b);

    return 0;
}