
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <syslog.h>

#define MAX_EVENT_LEN 512
#define MAX_LOG_FILES 10


typedef struct {
    char *message;
    int severity;
    struct tm timestamp;
} event_t;


void format_event(event_t *event, char *message, int severity) {
    char timestring[26];
    struct tm *tmp;

    
    gettimeofday(&event->timestamp, NULL);
    strftime(timestring, sizeof(timestring), "%Y-%m-%d %H:%M:%S", &event->timestamp);

    
    snprintf(message, MAX_EVENT_LEN, "%s [%d] %s", timestring, severity, event->message);
}


void log_event(event_t *event) {
    char *filename = "event.log";
    FILE *file = fopen(filename, "a");

    
    if (!file) {
        file = creat(filename, 0644);
        if (!file) {
            perror("Error creating log file");
            return;
        }
    }

    
    format_event(event, filename, 0);
    fwrite(filename, 1, strlen(filename), file);
    fwrite("\n", 1, 1, file);

    
    fclose(file);
}

int main() {
    
    event_t event = {
        .message = "Hello, world!",
        .severity = LOG_INFO,
        .timestamp = {1970, 1, 1, 0, 0, 0, 0}
    };

    
    log_event(&event);

    
    event.severity = LOG_WARNING;
    log_event(&event);

    
    event.message = "Goodbye, world!";
    log_event(&event);

    return 0;
}