//GEMINI-pro DATASET v1.0 Category: Image Editor ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    unsigned char r, g, b;
} pixel;

int main() {
    // Read the image from a file
    FILE *file = fopen("input.bmp", "rb");
    if (file == NULL) {
        printf("Error opening file.\n");
        return 1;
    }

    // Read the header of the BMP file
    unsigned char header[54];
    fread(header, 1, 54, file);

    // Check if the file is a valid BMP file
    if (header[0] != 'B' || header[1] != 'M') {
        printf("Error: File is not a valid BMP file.\n");
        fclose(file);
        return 1;
    }

    // Get the dimensions of the image
    int width = *(int*)&header[18];
    int height = *(int*)&header[22];

    // Read the pixel data from the file
    unsigned char *data = malloc(width * height * 3);
    fread(data, 1, width * height * 3, file);

    // Close the file
    fclose(file);

    // Create a new image with the same dimensions as the original image
    unsigned char *new_data = malloc(width * height * 3);

    // Apply a filter to the image
    for (int i = 0; i < width * height; i++) {
        // Get the pixel at the current index
        pixel p = { data[3*i], data[3*i+1], data[3*i+2] };

        // Apply the filter to the pixel
        // In this example, we will apply a simple grayscale filter
        unsigned char gray = (p.r + p.g + p.b) / 3;
        new_data[3*i] = gray;
        new_data[3*i+1] = gray;
        new_data[3*i+2] = gray;
    }

    // Write the new image to a file
    file = fopen("output.bmp", "wb");
    if (file == NULL) {
        printf("Error opening file.\n");
        return 1;
    }

    // Write the header of the BMP file
    fwrite(header, 1, 54, file);

    // Write the pixel data to the file
    fwrite(new_data, 1, width * height * 3, file);

    // Close the file
    fclose(file);

    // Free the memory allocated for the image data
    free(data);
    free(new_data);

    return 0;
}