//GEMINI-pro DATASET v1.0 Category: Encryption ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// The key used for encryption and decryption
const char *key = "My Secret Key";

// The function to encrypt a string using the XOR cipher
char *encrypt(char *text) {
  int keyLength = strlen(key);
  int textLength = strlen(text);
  char *encryptedText = malloc(textLength + 1);

  for (int i = 0; i < textLength; i++) {
    // XOR the current character with the corresponding character in the key
    encryptedText[i] = text[i] ^ key[i % keyLength];
  }

  // Terminate the encrypted text with a null character
  encryptedText[textLength] = '\0';

  return encryptedText;
}

// The function to decrypt a string using the XOR cipher
char *decrypt(char *encryptedText) {
  int keyLength = strlen(key);
  int encryptedTextLength = strlen(encryptedText);
  char *decryptedText = malloc(encryptedTextLength + 1);

  for (int i = 0; i < encryptedTextLength; i++) {
    // XOR the current character with the corresponding character in the key
    decryptedText[i] = encryptedText[i] ^ key[i % keyLength];
  }

  // Terminate the decrypted text with a null character
  decryptedText[encryptedTextLength] = '\0';

  return decryptedText;
}

// The function to encrypt a file
void encryptFile(char *inputFile, char *outputFile) {
  // Open the input file
  FILE *inputFilePointer = fopen(inputFile, "rb");
  if (inputFilePointer == NULL) {
    perror("Error opening input file");
    exit(1);
  }

  // Open the output file
  FILE *outputFilePointer = fopen(outputFile, "wb");
  if (outputFilePointer == NULL) {
    perror("Error opening output file");
    exit(1);
  }

  // Create a buffer to store the data read from the input file
  char buffer[1024];
  int bytesRead;

  // Encrypt the data in the input file and write it to the output file
  while ((bytesRead = fread(buffer, 1, sizeof(buffer), inputFilePointer)) > 0) {
    char *encryptedBuffer = encrypt(buffer);
    fwrite(encryptedBuffer, 1, bytesRead, outputFilePointer);
    free(encryptedBuffer);
  }

  // Close the input and output files
  fclose(inputFilePointer);
  fclose(outputFilePointer);
}

// The function to decrypt a file
void decryptFile(char *inputFile, char *outputFile) {
  // Open the input file
  FILE *inputFilePointer = fopen(inputFile, "rb");
  if (inputFilePointer == NULL) {
    perror("Error opening input file");
    exit(1);
  }

  // Open the output file
  FILE *outputFilePointer = fopen(outputFile, "wb");
  if (outputFilePointer == NULL) {
    perror("Error opening output file");
    exit(1);
  }

  // Create a buffer to store the data read from the input file
  char buffer[1024];
  int bytesRead;

  // Decrypt the data in the input file and write it to the output file
  while ((bytesRead = fread(buffer, 1, sizeof(buffer), inputFilePointer)) > 0) {
    char *decryptedBuffer = decrypt(buffer);
    fwrite(decryptedBuffer, 1, bytesRead, outputFilePointer);
    free(decryptedBuffer);
  }

  // Close the input and output files
  fclose(inputFilePointer);
  fclose(outputFilePointer);
}

int main() {
  // Encrypt a string
  char *plaintext = "Hello, world!";
  char *encryptedText = encrypt(plaintext);
  printf("Encrypted text: %s\n", encryptedText);

  // Decrypt the encrypted string
  char *decryptedText = decrypt(encryptedText);
  printf("Decrypted text: %s\n", decryptedText);

  // Encrypt a file
  encryptFile("input.txt", "output.enc");

  // Decrypt the encrypted file
  decryptFile("output.enc", "output.dec");

  return 0;
}