//Falcon-180B DATASET v1.0 Category: Color Code Converter ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

// Define the maximum length of the input string
#define MAX_LENGTH 100

// Define the color codes
#define BLACK "\033[30m"
#define RED "\033[31m"
#define GREEN "\033[32m"
#define YELLOW "\033[33m"
#define BLUE "\033[34m"
#define PURPLE "\033[35m"
#define CYAN "\033[36m"
#define WHITE "\033[37m"

// Function to convert a given string into a color code
char* color_code(char* input) {
    int length = strlen(input);
    char* output = malloc(MAX_LENGTH * sizeof(char));
    strcpy(output, "");

    // Loop through each character in the input string
    for (int i = 0; i < length; i++) {
        char c = tolower(input[i]);

        // Check if the character is a letter
        if (isalpha(c)) {
            // Convert the letter to a color code
            switch (c) {
                case 'a':
                case 'b':
                case 'c':
                case 'd':
                case 'e':
                case 'f':
                    strcat(output, GREEN);
                    break;
                case 'g':
                case 'h':
                case 'i':
                case 'j':
                case 'k':
                    strcat(output, YELLOW);
                    break;
                case 'l':
                case'm':
                case 'n':
                case 'o':
                case 'p':
                    strcat(output, PURPLE);
                    break;
                case 'q':
                case 'r':
                case's':
                case 't':
                case 'u':
                    strcat(output, CYAN);
                    break;
                case 'v':
                case 'w':
                case 'x':
                case 'y':
                case 'z':
                    strcat(output, BLUE);
                    break;
                default:
                    strcat(output, WHITE);
            }
        } else {
            // If the character is not a letter, add it to the output string as is
            strcat(output, input[i]);
        }
    }

    return output;
}

// Function to print a given string in a specific color code
void print_color(char* string, char* color_code) {
    printf("%s%s%s", color_code, string, WHITE);
}

// Main function
int main() {
    char input[MAX_LENGTH];

    // Prompt the user to enter a string
    printf("Enter a string: ");
    fgets(input, MAX_LENGTH, stdin);

    // Convert the input string into a color code
    char* color_code_output = color_code(input);

    // Print the original string and the color code string
    printf("Original string: %s\n", input);
    print_color(color_code_output, color_code_output);

    return 0;
}