
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <math.h>

#define KEY_SIZE 256
#define BLOCK_SIZE 16


uint8_t key[KEY_SIZE];


FILE *input_file;


FILE *output_file;


void encrypt(uint8_t *block) {
  for (int i = 0; i < BLOCK_SIZE; i++) {
    block[i] ^= key[i];
  }
}

int main(int argc, char *argv[]) {
  
  if (argc != 3) {
    fprintf(stderr, "Usage: %s <input_file> <output_file>\n", argv[0]);
    return 1;
  }

  
  input_file = fopen(argv[1], "rb");
  if (input_file == NULL) {
    fprintf(stderr, "Error opening input file: %s\n", argv[1]);
    return 1;
  }

  output_file = fopen(argv[2], "wb");
  if (output_file == NULL) {
    fprintf(stderr, "Error opening output file: %s\n", argv[2]);
    return 1;
  }

  
  for (int i = 0; i < KEY_SIZE; i++) {
    key[i] = (uint8_t) (256 * sin(i));
  }

  
  uint8_t block[BLOCK_SIZE];
  while (fread(block, BLOCK_SIZE, 1, input_file) == 1) {
    encrypt(block);
    fwrite(block, BLOCK_SIZE, 1, output_file);
  }

  
  fclose(input_file);
  fclose(output_file);

  return 0;
}