//Falcon-180B DATASET v1.0 Category: Metadata Extractor ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

#define MAX_TOKENS 100
#define MAX_TOKEN_LEN 100

typedef struct {
    char *name;
    char *value;
} metadata_t;

metadata_t *metadata = NULL;
int num_metadata = 0;

void add_metadata(char *name, char *value) {
    if (num_metadata >= MAX_TOKENS) {
        printf("Error: Too many metadata tokens.\n");
        return;
    }
    metadata_t *new_metadata = malloc(sizeof(metadata_t));
    strcpy(new_metadata->name, name);
    strcpy(new_metadata->value, value);
    metadata = realloc(metadata, sizeof(metadata_t) * (num_metadata + 1));
    metadata[num_metadata] = *new_metadata;
    num_metadata++;
}

void print_metadata() {
    for (int i = 0; i < num_metadata; i++) {
        printf("%s: %s\n", metadata[i].name, metadata[i].value);
    }
}

int main(int argc, char *argv[]) {
    if (argc < 2) {
        printf("Usage: %s <filename>\n", argv[0]);
        return 1;
    }
    FILE *file = fopen(argv[1], "r");
    if (file == NULL) {
        printf("Error: Could not open file.\n");
        return 1;
    }
    char line[MAX_TOKEN_LEN];
    char *token = NULL;
    size_t len = 0;
    while (fgets(line, MAX_TOKEN_LEN, file)!= NULL) {
        len = strlen(line);
        if (len == 0 || line[len - 1]!= '\n') {
            printf("Error: Invalid line in file.\n");
            fclose(file);
            return 1;
        }
        line[len - 1] = '\0';
        token = strtok(line, ":");
        while (token!= NULL) {
            if (strlen(token) > MAX_TOKEN_LEN - 1) {
                printf("Error: Token too long.\n");
                fclose(file);
                return 1;
            }
            add_metadata(token, strtok(NULL, ":"));
            token = strtok(NULL, ":");
        }
    }
    fclose(file);
    print_metadata();
    return 0;
}