//Falcon-180B DATASET v1.0 Category: Image to ASCII art converter ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#define MAX_WIDTH 100
#define MAX_HEIGHT 100
#define CHAR_SET ".:*+=-0123456789ABCDEF"

int get_pixel(int x, int y, unsigned char *image, int width, int height)
{
    if (x < 0 || x >= width || y < 0 || y >= height)
        return 0;
    return image[(y * width) + x];
}

void ascii_art(int x, int y, unsigned char *image, int width, int height)
{
    int i, j, value;
    char ascii_char;

    for (i = 0; i < height; i++) {
        for (j = 0; j < width; j++) {
            value = get_pixel(j, i, image, width, height);
            ascii_char = CHAR_SET[value % strlen(CHAR_SET)];
            printf("%c", ascii_char);
        }
        printf("\n");
    }
}

int main(int argc, char *argv[])
{
    unsigned char *image;
    int width, height, max_value;
    FILE *fp;

    if (argc!= 3) {
        printf("Usage: %s <input_file> <output_file>\n", argv[0]);
        return 1;
    }

    fp = fopen(argv[1], "rb");
    if (fp == NULL) {
        printf("Error: Could not open input file.\n");
        return 1;
    }

    fseek(fp, 0, SEEK_END);
    width = ftell(fp) / 3;
    height = ftell(fp) / (3 * width);
    rewind(fp);

    image = (unsigned char *) malloc(width * height * 3);
    if (image == NULL) {
        printf("Error: Could not allocate memory.\n");
        fclose(fp);
        return 1;
    }

    fread(image, 3, width * height, fp);
    fclose(fp);

    max_value = 0;
    for (int i = 0; i < width * height; i++) {
        if (image[i] > max_value)
            max_value = image[i];
    }

    printf("Pixels: %d\n", max_value);
    ascii_art(0, 0, image, width, height);

    return 0;
}