//Falcon-180B DATASET v1.0 Category: Resume Parsing System ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_TOKENS 1000

typedef struct {
    char *name;
    char *value;
} Token;

typedef struct {
    int num_tokens;
    Token tokens[MAX_TOKENS];
} Resume;

void add_token(Resume *resume, char *name, char *value) {
    int i;
    for (i = 0; i < resume->num_tokens; i++) {
        if (strcmp(resume->tokens[i].name, name) == 0) {
            resume->tokens[i].value = value;
            return;
        }
    }
    if (resume->num_tokens >= MAX_TOKENS) {
        printf("Error: Too many tokens\n");
        exit(1);
    }
    resume->tokens[resume->num_tokens].name = strdup(name);
    resume->tokens[resume->num_tokens].value = strdup(value);
    resume->num_tokens++;
}

void print_resume(Resume *resume) {
    int i;
    for (i = 0; i < resume->num_tokens; i++) {
        printf("%s: %s\n", resume->tokens[i].name, resume->tokens[i].value);
    }
}

int main() {
    char line[1024];
    char *name, *value;
    Resume resume = {0};

    while (fgets(line, sizeof(line), stdin)!= NULL) {
        name = strtok(line, ":");
        value = strtok(NULL, "\n");
        if (name == NULL || value == NULL) {
            printf("Error: Invalid line\n");
            exit(1);
        }
        add_token(&resume, name, value);
    }

    print_resume(&resume);

    return 0;
}