//Falcon2-11B DATASET v1.0 Category: Compression algorithms ; Style: Alan Turing
#include <stdio.h>

// Simple compression method
void simple_compress(char* string) {
    int freq[26] = {0};
    char compressed[strlen(string) + 1];
    
    for (int i = 0; i < strlen(string); i++) {
        freq[string[i] - 'a']++;
    }
    
    for (int i = 0; i < strlen(string); i++) {
        compressed[i] = freq[string[i] - 'a'];
    }
    
    compressed[strlen(string)] = '\0';
    printf("Compressed string: %s\n", compressed);
}

// Complex compression method using Huffman coding
void huffman_compress(char* string) {
    int freq[26] = {0};
    char* compressed[strlen(string) + 1];
    int i = 0;
    
    for (int i = 0; i < strlen(string); i++) {
        freq[string[i] - 'a']++;
    }
    
    int total_freq = 0;
    for (int i = 0; i < 26; i++) {
        total_freq += freq[i];
    }
    
    for (int i = 0; i < 26; i++) {
        freq[i] /= total_freq;
    }
    
    char* node = malloc(sizeof(char) * 2);
    node[0] = '0';
    node[1] = '0';
    int node_freq = freq[0];
    freq[0] = 0;
    
    for (int i = 1; i < 26; i++) {
        if (freq[i] > node_freq) {
            node_freq = freq[i];
            node[0] = '1';
            node[1] = i + 'a';
        }
    }
    
    for (int i = 0; i < strlen(string); i++) {
        int code = node[0];
        int index = node[1] - 'a';
        while (code > 0) {
            if (index < strlen(compressed)) {
                compressed[index] = code;
            } else {
                compressed[index] = code - 1;
            }
            code = (code - 1) / 2;
            index += (code - 1) % 2;
        }
    }
    
    for (int i = 0; i < strlen(compressed); i++) {
        printf("%c", compressed[i]);
    }
    printf("\n");
}

int main() {
    char string[] = "aabbc";
    simple_compress(string);
    huffman_compress(string);
    return 0;
}