//Falcon-180B DATASET v1.0 Category: Time Travel Simulator ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_EVENTS 1000

// structure to hold event data
typedef struct {
    time_t timestamp;
    int type;
    char *message;
} Event;

// function prototypes
void add_event(Event *events, int *num_events, time_t timestamp, int type, char *message);
void print_events(Event *events, int num_events);
void time_travel(Event *events, int num_events, time_t target_time);

int main() {
    Event events[MAX_EVENTS];
    int num_events = 0;

    // add some initial events
    add_event(events, &num_events, time(NULL), 1, "Program started");
    add_event(events, &num_events, time(NULL) + 5, 2, "First message");
    add_event(events, &num_events, time(NULL) + 10, 3, "Second message");

    // print the initial timeline
    printf("Initial timeline:\n");
    print_events(events, num_events);

    // time travel to the future
    time_travel(events, num_events, time(NULL) + 60);

    // print the updated timeline
    printf("\nTimeline after time travel:\n");
    print_events(events, num_events);

    return 0;
}

void add_event(Event *events, int *num_events, time_t timestamp, int type, char *message) {
    if (*num_events >= MAX_EVENTS) {
        printf("Error: maximum number of events reached\n");
        return;
    }

    events[*num_events].timestamp = timestamp;
    events[*num_events].type = type;
    events[*num_events].message = strdup(message);

    (*num_events)++;
}

void print_events(Event *events, int num_events) {
    for (int i = 0; i < num_events; i++) {
        printf("%ld: %d - %s\n", events[i].timestamp, events[i].type, events[i].message);
    }
}

void time_travel(Event *events, int num_events, time_t target_time) {
    for (int i = 0; i < num_events; i++) {
        if (events[i].timestamp > target_time) {
            events[i].timestamp -= target_time - time(NULL);
        }
    }
}