//GPT-4o-mini DATASET v1.0 Category: Math exercise ; Style: mathematical
#include <stdio.h>
#include <math.h>

#define MAX_TERMS 100

// Function to calculate factorial of a number
unsigned long long factorial(int n) {
    if (n < 0) return 0;
    unsigned long long result = 1;
    for (int i = 1; i <= n; i++) {
        result *= i;
    }
    return result;
}

// Function to compute sine of x using Taylor series expansion
double sine(double x) {
    double sin_val = 0.0;
    for (int n = 0; n < MAX_TERMS; n++) {
        double term = pow(-1, n) * pow(x, 2 * n + 1) / factorial(2 * n + 1);
        sin_val += term;
    }
    return sin_val;
}

// Function to compute cosine of x using Taylor series expansion
double cosine(double x) {
    double cos_val = 0.0;
    for (int n = 0; n < MAX_TERMS; n++) {
        double term = pow(-1, n) * pow(x, 2 * n) / factorial(2 * n);
        cos_val += term;
    }
    return cos_val;
}

// Function to compute tangent of x
double tangent(double x) {
    return sine(x) / cosine(x);
}

// Function to compute exponential of x using Taylor series expansion
double exponential(double x) {
    double exp_val = 0.0;
    for (int n = 0; n < MAX_TERMS; n++) {
        double term = pow(x, n) / factorial(n);
        exp_val += term;
    }
    return exp_val;
}

// Function to compute natural logarithm of (1+x) using Taylor series
double ln_one_plus_x(double x) {
    if (x <= -1) {
        printf("ln(1+x) is undefined for x <= -1\n");
        return NAN;
    }
    double ln_val = 0.0;
    for (int n = 1; n <= MAX_TERMS; n++) {
        double term = pow((-1), n + 1) * pow(x, n) / n;
        ln_val += term;
    }
    return ln_val;
}

// Function to compute the nth root of a number using Newton's method
double nth_root(double a, int n) {
    double x_n = a; // Initial guess
    double x_n1;
    do {
        x_n1 = ((n - 1) * x_n + a / pow(x_n, n - 1)) / n;
        if (fabs(x_n1 - x_n) < 1e-10) break; // Close enough
        x_n = x_n1;
    } while (1);
    return x_n1;
}

int main() {
    double angle;
    
    // Sine and Cosine example
    printf("Enter angle in radians for sine and cosine calculation: ");
    scanf("%lf", &angle);
    printf("Sine(%lf) = %lf\n", angle, sine(angle));
    printf("Cosine(%lf) = %lf\n", angle, cosine(angle));
    printf("Tangent(%lf) = %lf\n", angle, tangent(angle));

    // Exponential example
    double exp_input;
    printf("Enter a number to calculate its exponential: ");
    scanf("%lf", &exp_input);
    printf("Exponential(%lf) = %lf\n", exp_input, exponential(exp_input));

    // Natural Logarithm example
    double ln_input;
    printf("Enter a number (x > -1) to calculate ln(1+x): ");
    scanf("%lf", &ln_input);
    printf("ln(1 + %lf) = %lf\n", ln_input, ln_one_plus_x(ln_input));

    // Nth root calculation
    double root_input;
    int n;
    printf("Enter a number to calculate its nth root: ");
    scanf("%lf", &root_input);
    printf("Enter the root: ");
    scanf("%d", &n);
    printf("The %dth root of %lf is %lf\n", n, root_input, nth_root(root_input, n));

    return 0;
}