//GPT-4o-mini DATASET v1.0 Category: Subnet Calculator ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Structure to hold IP and subnet information
struct SubnetInfo {
    unsigned char ip[4];
    unsigned char subnetMask[4];
    unsigned char networkAddress[4];
    unsigned char broadcastAddress[4];
    int totalHosts;
};

// Function to split a string by '.' and convert it to an array of unsigned chars
void parseIP(const char *ipStr, unsigned char *ip) {
    char *token;
    char str[16];
    strcpy(str, ipStr); // Create a mutable copy of the string
    token = strtok(str, ".");
    for (int i = 0; i < 4 && token != NULL; i++) {
        ip[i] = (unsigned char) atoi(token);
        token = strtok(NULL, ".");
    }
}

// Function to calculate subnet details
void calculateSubnet(struct SubnetInfo *info) {
    // Calculate the network address
    for (int i = 0; i < 4; i++) {
        info->networkAddress[i] = info->ip[i] & info->subnetMask[i];
    }

    // Calculate the broadcast address
    for (int i = 0; i < 4; i++) {
        info->broadcastAddress[i] = info->networkAddress[i] | (~info->subnetMask[i] & 0xFF);
    }

    // Calculate total hosts
    int mask = 0;
    for (int i = 0; i < 4; i++) {
        mask += __builtin_popcount(info->subnetMask[i]);
    }
    info->totalHosts = (1 << (32 - mask)) - 2; // -2 for network and broadcast
}

// Function to display the results
void displayResults(struct SubnetInfo *info) {
    printf("\nHere's what I found:\n");
    printf("Your IP Address: %d.%d.%d.%d\n", info->ip[0], info->ip[1], info->ip[2], info->ip[3]);
    printf("Subnet Mask: %d.%d.%d.%d\n", info->subnetMask[0], info->subnetMask[1], info->subnetMask[2], info->subnetMask[3]);
    printf("Network Address: %d.%d.%d.%d\n", info->networkAddress[0], info->networkAddress[1], info->networkAddress[2], info->networkAddress[3]);
    printf("Broadcast Address: %d.%d.%d.%d\n", info->broadcastAddress[0], info->broadcastAddress[1], info->broadcastAddress[2], info->broadcastAddress[3]);
    printf("Total Hosts in this Subnet: %d\n", info->totalHosts);
}

// Main function
int main() {
    struct SubnetInfo subnetInfo;
    char ipStr[16];
    char subnetStr[16];

    printf("Welcome to the Relaxed Subnet Calculator!\n");
    printf("Please enter an IP address (format: xxx.xxx.xxx.xxx): ");
    fgets(ipStr, sizeof(ipStr), stdin);
    ipStr[strcspn(ipStr, "\n")] = 0; // Remove trailing newline

    printf("Great! Now, enter the subnet mask (again, format: xxx.xxx.xxx.xxx): ");
    fgets(subnetStr, sizeof(subnetStr), stdin);
    subnetStr[strcspn(subnetStr, "\n")] = 0; // Remove trailing newline

    // Parse the IP and subnet mask
    parseIP(ipStr, subnetInfo.ip);
    parseIP(subnetStr, subnetInfo.subnetMask);

    // Calculate subnet information
    calculateSubnet(&subnetInfo);

    // Display the results
    displayResults(&subnetInfo);

    printf("\nThanks for using the Relaxed Subnet Calculator! Have a great day!\n");
    
    return 0;
}