//Falcon-180B DATASET v1.0 Category: URL Sanitizer ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>

#define MAX_URL_LEN 4096 // maximum length of a URL

typedef struct {
    char *url;
    size_t len;
} url_t;

// function to sanitize a URL
url_t sanitize_url(const char *input_url) {
    url_t output_url = {0};
    char *url = strdup(input_url);
    size_t len = strlen(url);

    // remove any leading or trailing whitespace
    while (isspace(url[0])) {
        memmove(url, &url[1], len - 1);
        len--;
    }
    while (isspace(url[len - 1])) {
        len--;
        url[len] = '\0';
    }

    // remove any invalid characters
    char *invalid_chars = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
    for (size_t i = 0; i < len; i++) {
        if (strchr(invalid_chars, url[i])!= NULL) {
            url[i] = '%';
            len += 2;
            url = realloc(url, len + 1);
            sprintf(&url[i + 1], "%02X", (unsigned char)url[i]);
        }
    }

    output_url.url = url;
    output_url.len = len;

    return output_url;
}

// function to print a URL
void print_url(const url_t *url) {
    printf("%s\n", url->url);
}

int main() {
    char *input_url = "https://www.example.com/path?query=string#fragment";
    url_t sanitized_url = sanitize_url(input_url);
    print_url(&sanitized_url);

    free(sanitized_url.url);
    return 0;
}